import QtQuick 2.3

import AdaptDemoSystem 1.0

Group {
    id: group
    property string file
    property string textureRT
    property string shader: "fx/_SharedQML/overlay"

    property real posX: 0.0
    property real posY: 0.0

    property bool flip: true
    property real overlayAlpha: 1.0

    property real overlayScale: 1.0

    property string textureWrap: "clamp"

    Blit {
        textureRT: "colorBuffer"
    }
    Shader {
        file: group.shader
    }
    Texture {
        textureUnit: 0
        textureRT: "colorBuffer"
    }

    Texture {
        textureUnit: 1
        textureItem: kuvakuva
        Image {
            id: kuvakuva
            visible: false
            source: "../../images/"+group.file
        }
        textureWrap: group.textureWrap
    }

    Texture {
        enabled: group.textureRT !== ""
        textureUnit: 1
        textureRT: group.textureRT
    }

    DrawVB {
        ShaderParam {
            paramName: "flip"
            paramValue: group.flip ? 1.0 : 0.0
        }
        ShaderParam {
            paramName: "overlayAlpha"
            paramValue: overlayAlpha
        }
        ShaderParam {
            paramName: "g_overlayScale"
            paramValue: overlayScale
        }
        ShaderParam {
            paramName: "g_posX"
            paramValue: group.posX
        }
        ShaderParam {
            paramName: "g_posY"
            paramValue: group.posY
        }

        type: "quad"
        depthTest: false
        depthWrite: false
        drawBuffers: 1
        blendMode: "off"
    }


}

